import { Injectable } from '@nestjs/common';
import { Repository } from 'typeorm';
import { User } from './user.entity';
import { InjectRepository } from '@nestjs/typeorm';
import * as bcrypt from 'bcryptjs';

@Injectable()
export class UsersService {
  constructor(
    @InjectRepository(User)
    private usersRepo: Repository<User>,
  ) {}

  async create(username: string, password: string, email?: string) {
    const hashed = await bcrypt.hash(password, 10);
    const user = this.usersRepo.create({ username, password: hashed, email });
    return this.usersRepo.save(user);
  }

  findAll() {
    return this.usersRepo.find({ select: ['id','username','email'] });
  }

  findOneById(id: number) {
    return this.usersRepo.findOneBy({ id });
  }

  findByUsername(username: string) {
    return this.usersRepo.findOneBy({ username });
  }

  async update(id: number, attrs: Partial<User>) {
    const user = await this.usersRepo.findOneBy({ id });
    if (!user) return null;
    if (attrs.password) {
      attrs.password = await bcrypt.hash(attrs.password as string, 10);
    }
    Object.assign(user, attrs);
    return this.usersRepo.save(user);
  }

  async remove(id: number) {
    return this.usersRepo.delete({ id });
  }
}
